package parser;

/**
 * Factory for N grammar non-terminal objects.
 */
public class NFact extends ATVFactory {
    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object param) {
            // change state to no-op
            _initializer = NoOpLambda.Singleton;

            // nothing to initialize
            return null;
        }
    };

    /**
     * Constructor for the N factory.
     *
     * @param tkz tokenizer to use
     */
    public NFact(ITokenizer tkz) {
        super(tkz);
    }

    /**
     * Make the visitor.
     */
    private void initialize() {
        _initializer.apply(null);
    }

    /**
     * Make a token visitor to parse an N non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        initialize();
        return new NumToken.INumVisitor() {
            public Object numCase(NumToken host, Object inp) {
                return new N(host);
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        initialize();
        return new NumToken.AChainVis(successor) {
            public Object numCase(NumToken host, Object inp) {
                return new N(host);
            }
        };
    }
}

